{{{
    globalThis.__HAVE_EMDAWNWEBGPU_ENUM_TABLES = true;

    // Constant values used at code-generation time in an Emscripten build.
    // These will not appear in the final build result, so we can just dump
    // every enum here without affecting binary size.
    globalThis.WEBGPU_ENUM_CONSTANT_TABLES = {
        AdapterType: {
            'DiscreteGPU': 1,
            'IntegratedGPU': 2,
            'CPU': 3,
            'Unknown': 4,
        },
        AddressMode: {
            'Undefined': 0,
            'ClampToEdge': 1,
            'Repeat': 2,
            'MirrorRepeat': 3,
        },
        BackendType: {
            'Undefined': 0,
            'Null': 1,
            'WebGPU': 2,
            'D3D11': 3,
            'D3D12': 4,
            'Metal': 5,
            'Vulkan': 6,
            'OpenGL': 7,
            'OpenGLES': 8,
        },
        BlendFactor: {
            'Undefined': 0,
            'Zero': 1,
            'One': 2,
            'Src': 3,
            'OneMinusSrc': 4,
            'SrcAlpha': 5,
            'OneMinusSrcAlpha': 6,
            'Dst': 7,
            'OneMinusDst': 8,
            'DstAlpha': 9,
            'OneMinusDstAlpha': 10,
            'SrcAlphaSaturated': 11,
            'Constant': 12,
            'OneMinusConstant': 13,
            'Src1': 14,
            'OneMinusSrc1': 15,
            'Src1Alpha': 16,
            'OneMinusSrc1Alpha': 17,
        },
        BlendOperation: {
            'Undefined': 0,
            'Add': 1,
            'Subtract': 2,
            'ReverseSubtract': 3,
            'Min': 4,
            'Max': 5,
        },
        BufferBindingType: {
            'BindingNotUsed': 0,
            'Undefined': 1,
            'Uniform': 2,
            'Storage': 3,
            'ReadOnlyStorage': 4,
        },
        BufferMapState: {
            'Unmapped': 1,
            'Pending': 2,
            'Mapped': 3,
        },
        CallbackMode: {
            'WaitAnyOnly': 1,
            'AllowProcessEvents': 2,
            'AllowSpontaneous': 3,
        },
        CompareFunction: {
            'Undefined': 0,
            'Never': 1,
            'Less': 2,
            'Equal': 3,
            'LessEqual': 4,
            'Greater': 5,
            'NotEqual': 6,
            'GreaterEqual': 7,
            'Always': 8,
        },
        CompilationInfoRequestStatus: {
            'Success': 1,
            'CallbackCancelled': 2,
        },
        CompilationMessageType: {
            'Error': 1,
            'Warning': 2,
            'Info': 3,
        },
        CompositeAlphaMode: {
            'Auto': 0,
            'Opaque': 1,
            'Premultiplied': 2,
            'Unpremultiplied': 3,
            'Inherit': 4,
        },
        CreatePipelineAsyncStatus: {
            'Success': 1,
            'CallbackCancelled': 2,
            'ValidationError': 3,
            'InternalError': 4,
        },
        CullMode: {
            'Undefined': 0,
            'None': 1,
            'Front': 2,
            'Back': 3,
        },
        DeviceLostReason: {
            'Unknown': 1,
            'Destroyed': 2,
            'CallbackCancelled': 3,
            'FailedCreation': 4,
        },
        ErrorFilter: {
            'Validation': 1,
            'OutOfMemory': 2,
            'Internal': 3,
        },
        ErrorType: {
            'NoError': 1,
            'Validation': 2,
            'OutOfMemory': 3,
            'Internal': 4,
            'Unknown': 5,
        },
        FeatureLevel: {
            'Undefined': 0,
            'Compatibility': 1,
            'Core': 2,
        },
        FeatureName: {
            'CoreFeaturesAndLimits': 1,
            'DepthClipControl': 2,
            'Depth32FloatStencil8': 3,
            'TextureCompressionBC': 4,
            'TextureCompressionBCSliced3D': 5,
            'TextureCompressionETC2': 6,
            'TextureCompressionASTC': 7,
            'TextureCompressionASTCSliced3D': 8,
            'TimestampQuery': 9,
            'IndirectFirstInstance': 10,
            'ShaderF16': 11,
            'RG11B10UfloatRenderable': 12,
            'BGRA8UnormStorage': 13,
            'Float32Filterable': 14,
            'Float32Blendable': 15,
            'ClipDistances': 16,
            'DualSourceBlending': 17,
            'Subgroups': 18,
            'TextureFormatsTier1': 19,
            'TextureFormatsTier2': 20,
            'PrimitiveIndex': 21,
            'Unorm16TextureFormats': 327692,
            'Snorm16TextureFormats': 327693,
            'MultiDrawIndirect': 327732,
        },
        FilterMode: {
            'Undefined': 0,
            'Nearest': 1,
            'Linear': 2,
        },
        FrontFace: {
            'Undefined': 0,
            'CCW': 1,
            'CW': 2,
        },
        IndexFormat: {
            'Undefined': 0,
            'Uint16': 1,
            'Uint32': 2,
        },
        InstanceFeatureName: {
            'TimedWaitAny': 1,
            'ShaderSourceSPIRV': 2,
            'MultipleDevicesPerAdapter': 3,
        },
        LoadOp: {
            'Undefined': 0,
            'Load': 1,
            'Clear': 2,
        },
        MapAsyncStatus: {
            'Success': 1,
            'CallbackCancelled': 2,
            'Error': 3,
            'Aborted': 4,
        },
        MipmapFilterMode: {
            'Undefined': 0,
            'Nearest': 1,
            'Linear': 2,
        },
        OptionalBool: {
            'False': 0,
            'True': 1,
            'Undefined': 2,
        },
        PopErrorScopeStatus: {
            'Success': 1,
            'CallbackCancelled': 2,
            'Error': 3,
        },
        PowerPreference: {
            'Undefined': 0,
            'LowPower': 1,
            'HighPerformance': 2,
        },
        PredefinedColorSpace: {
            'SRGB': 1,
            'DisplayP3': 2,
        },
        PresentMode: {
            'Undefined': 0,
            'Fifo': 1,
            'FifoRelaxed': 2,
            'Immediate': 3,
            'Mailbox': 4,
        },
        PrimitiveTopology: {
            'Undefined': 0,
            'PointList': 1,
            'LineList': 2,
            'LineStrip': 3,
            'TriangleList': 4,
            'TriangleStrip': 5,
        },
        QueryType: {
            'Occlusion': 1,
            'Timestamp': 2,
        },
        QueueWorkDoneStatus: {
            'Success': 1,
            'CallbackCancelled': 2,
            'Error': 3,
        },
        RequestAdapterStatus: {
            'Success': 1,
            'CallbackCancelled': 2,
            'Unavailable': 3,
            'Error': 4,
        },
        RequestDeviceStatus: {
            'Success': 1,
            'CallbackCancelled': 2,
            'Error': 3,
        },
        SamplerBindingType: {
            'BindingNotUsed': 0,
            'Undefined': 1,
            'Filtering': 2,
            'NonFiltering': 3,
            'Comparison': 4,
        },
        Status: {
            'Success': 1,
            'Error': 2,
        },
        StencilOperation: {
            'Undefined': 0,
            'Keep': 1,
            'Zero': 2,
            'Replace': 3,
            'Invert': 4,
            'IncrementClamp': 5,
            'DecrementClamp': 6,
            'IncrementWrap': 7,
            'DecrementWrap': 8,
        },
        StorageTextureAccess: {
            'BindingNotUsed': 0,
            'Undefined': 1,
            'WriteOnly': 2,
            'ReadOnly': 3,
            'ReadWrite': 4,
        },
        StoreOp: {
            'Undefined': 0,
            'Store': 1,
            'Discard': 2,
        },
        SType: {
            'ShaderSourceSPIRV': 1,
            'ShaderSourceWGSL': 2,
            'RenderPassMaxDrawCount': 3,
            'SurfaceSourceMetalLayer': 4,
            'SurfaceSourceWindowsHWND': 5,
            'SurfaceSourceXlibWindow': 6,
            'SurfaceSourceWaylandSurface': 7,
            'SurfaceSourceAndroidNativeWindow': 8,
            'SurfaceSourceXCBWindow': 9,
            'SurfaceColorManagement': 10,
            'RequestAdapterWebXROptions': 11,
            'CompatibilityModeLimits': 131072,
            'TextureBindingViewDimensionDescriptor': 131073,
            'EmscriptenSurfaceSourceCanvasHTMLSelector': 262144,
            'DawnCompilationMessageUtf16': 327743,
        },
        SurfaceGetCurrentTextureStatus: {
            'SuccessOptimal': 1,
            'SuccessSuboptimal': 2,
            'Timeout': 3,
            'Outdated': 4,
            'Lost': 5,
            'Error': 6,
        },
        TextureAspect: {
            'Undefined': 0,
            'All': 1,
            'StencilOnly': 2,
            'DepthOnly': 3,
        },
        TextureDimension: {
            'Undefined': 0,
            '1D': 1,
            '2D': 2,
            '3D': 3,
        },
        TextureFormat: {
            'Undefined': 0,
            'R8Unorm': 1,
            'R8Snorm': 2,
            'R8Uint': 3,
            'R8Sint': 4,
            'R16Unorm': 5,
            'R16Snorm': 6,
            'R16Uint': 7,
            'R16Sint': 8,
            'R16Float': 9,
            'RG8Unorm': 10,
            'RG8Snorm': 11,
            'RG8Uint': 12,
            'RG8Sint': 13,
            'R32Float': 14,
            'R32Uint': 15,
            'R32Sint': 16,
            'RG16Unorm': 17,
            'RG16Snorm': 18,
            'RG16Uint': 19,
            'RG16Sint': 20,
            'RG16Float': 21,
            'RGBA8Unorm': 22,
            'RGBA8UnormSrgb': 23,
            'RGBA8Snorm': 24,
            'RGBA8Uint': 25,
            'RGBA8Sint': 26,
            'BGRA8Unorm': 27,
            'BGRA8UnormSrgb': 28,
            'RGB10A2Uint': 29,
            'RGB10A2Unorm': 30,
            'RG11B10Ufloat': 31,
            'RGB9E5Ufloat': 32,
            'RG32Float': 33,
            'RG32Uint': 34,
            'RG32Sint': 35,
            'RGBA16Unorm': 36,
            'RGBA16Snorm': 37,
            'RGBA16Uint': 38,
            'RGBA16Sint': 39,
            'RGBA16Float': 40,
            'RGBA32Float': 41,
            'RGBA32Uint': 42,
            'RGBA32Sint': 43,
            'Stencil8': 44,
            'Depth16Unorm': 45,
            'Depth24Plus': 46,
            'Depth24PlusStencil8': 47,
            'Depth32Float': 48,
            'Depth32FloatStencil8': 49,
            'BC1RGBAUnorm': 50,
            'BC1RGBAUnormSrgb': 51,
            'BC2RGBAUnorm': 52,
            'BC2RGBAUnormSrgb': 53,
            'BC3RGBAUnorm': 54,
            'BC3RGBAUnormSrgb': 55,
            'BC4RUnorm': 56,
            'BC4RSnorm': 57,
            'BC5RGUnorm': 58,
            'BC5RGSnorm': 59,
            'BC6HRGBUfloat': 60,
            'BC6HRGBFloat': 61,
            'BC7RGBAUnorm': 62,
            'BC7RGBAUnormSrgb': 63,
            'ETC2RGB8Unorm': 64,
            'ETC2RGB8UnormSrgb': 65,
            'ETC2RGB8A1Unorm': 66,
            'ETC2RGB8A1UnormSrgb': 67,
            'ETC2RGBA8Unorm': 68,
            'ETC2RGBA8UnormSrgb': 69,
            'EACR11Unorm': 70,
            'EACR11Snorm': 71,
            'EACRG11Unorm': 72,
            'EACRG11Snorm': 73,
            'ASTC4x4Unorm': 74,
            'ASTC4x4UnormSrgb': 75,
            'ASTC5x4Unorm': 76,
            'ASTC5x4UnormSrgb': 77,
            'ASTC5x5Unorm': 78,
            'ASTC5x5UnormSrgb': 79,
            'ASTC6x5Unorm': 80,
            'ASTC6x5UnormSrgb': 81,
            'ASTC6x6Unorm': 82,
            'ASTC6x6UnormSrgb': 83,
            'ASTC8x5Unorm': 84,
            'ASTC8x5UnormSrgb': 85,
            'ASTC8x6Unorm': 86,
            'ASTC8x6UnormSrgb': 87,
            'ASTC8x8Unorm': 88,
            'ASTC8x8UnormSrgb': 89,
            'ASTC10x5Unorm': 90,
            'ASTC10x5UnormSrgb': 91,
            'ASTC10x6Unorm': 92,
            'ASTC10x6UnormSrgb': 93,
            'ASTC10x8Unorm': 94,
            'ASTC10x8UnormSrgb': 95,
            'ASTC10x10Unorm': 96,
            'ASTC10x10UnormSrgb': 97,
            'ASTC12x10Unorm': 98,
            'ASTC12x10UnormSrgb': 99,
            'ASTC12x12Unorm': 100,
            'ASTC12x12UnormSrgb': 101,
        },
        TextureSampleType: {
            'BindingNotUsed': 0,
            'Undefined': 1,
            'Float': 2,
            'UnfilterableFloat': 3,
            'Depth': 4,
            'Sint': 5,
            'Uint': 6,
        },
        TextureViewDimension: {
            'Undefined': 0,
            '1D': 1,
            '2D': 2,
            '2DArray': 3,
            'Cube': 4,
            'CubeArray': 5,
            '3D': 6,
        },
        ToneMappingMode: {
            'Standard': 1,
            'Extended': 2,
        },
        VertexFormat: {
            'Uint8': 1,
            'Uint8x2': 2,
            'Uint8x4': 3,
            'Sint8': 4,
            'Sint8x2': 5,
            'Sint8x4': 6,
            'Unorm8': 7,
            'Unorm8x2': 8,
            'Unorm8x4': 9,
            'Snorm8': 10,
            'Snorm8x2': 11,
            'Snorm8x4': 12,
            'Uint16': 13,
            'Uint16x2': 14,
            'Uint16x4': 15,
            'Sint16': 16,
            'Sint16x2': 17,
            'Sint16x4': 18,
            'Unorm16': 19,
            'Unorm16x2': 20,
            'Unorm16x4': 21,
            'Snorm16': 22,
            'Snorm16x2': 23,
            'Snorm16x4': 24,
            'Float16': 25,
            'Float16x2': 26,
            'Float16x4': 27,
            'Float32': 28,
            'Float32x2': 29,
            'Float32x3': 30,
            'Float32x4': 31,
            'Uint32': 32,
            'Uint32x2': 33,
            'Uint32x3': 34,
            'Uint32x4': 35,
            'Sint32': 36,
            'Sint32x2': 37,
            'Sint32x3': 38,
            'Sint32x4': 39,
            'Unorm10_10_10_2': 40,
            'Unorm8x4BGRA': 41,
        },
        VertexStepMode: {
            'Undefined': 0,
            'Vertex': 1,
            'Instance': 2,
        },
        WaitStatus: {
            'Success': 1,
            'TimedOut': 2,
            'Error': 3,
        },
        WGSLLanguageFeatureName: {
            'ReadonlyAndReadwriteStorageTextures': 1,
            'Packed4x8IntegerDotProduct': 2,
            'UnrestrictedPointerParameters': 3,
            'PointerCompositeAccess': 4,
        },
        BufferUsage: {
            'None': 0,
            'MapRead': 1,
            'MapWrite': 2,
            'CopySrc': 4,
            'CopyDst': 8,
            'Index': 16,
            'Vertex': 32,
            'Uniform': 64,
            'Storage': 128,
            'Indirect': 256,
            'QueryResolve': 512,
        },
        ColorWriteMask: {
            'None': 0,
            'Red': 1,
            'Green': 2,
            'Blue': 4,
            'Alpha': 8,
            'All': 15,
        },
        MapMode: {
            'None': 0,
            'Read': 1,
            'Write': 2,
        },
        ShaderStage: {
            'None': 0,
            'Vertex': 1,
            'Fragment': 2,
            'Compute': 4,
        },
        TextureUsage: {
            'None': 0,
            'CopySrc': 1,
            'CopyDst': 2,
            'TextureBinding': 4,
            'StorageBinding': 8,
            'RenderAttachment': 16,
        },
    };

    // Maps from enum string back to enum number, for callbacks.
    // These appear in the final build result so should be kept minimal.
    // (These are library-level items, which means they can be eliminated if
    // they're unreachable. The $ prefix means they're used only by other JS
    // code, not imported to Wasm. They're wrapped as strings so that Emscripten
    // inserts them verbatim rather than parsing then reserializing them, to
    // preserve the quotation marks needed to prevent Closure minification.)
    globalThis.WEBGPU_STRING_TO_INT_TABLES = `
        $emwgpuStringToInt_BufferMapState: \`{
            'unmapped': 1,
            'pending': 2,
            'mapped': 3,
        }\`,
        $emwgpuStringToInt_CompilationMessageType: \`{
            'error': 1,
            'warning': 2,
            'info': 3,
        }\`,
        $emwgpuStringToInt_DeviceLostReason: \`{
            'undefined': 1,  // For older browsers
            'unknown': 1,
            'destroyed': 2,
        }\`,
        $emwgpuStringToInt_FeatureName: \`{
            'core-features-and-limits': 1,
            'depth-clip-control': 2,
            'depth32float-stencil8': 3,
            'texture-compression-bc': 4,
            'texture-compression-bc-sliced-3d': 5,
            'texture-compression-etc2': 6,
            'texture-compression-astc': 7,
            'texture-compression-astc-sliced-3d': 8,
            'timestamp-query': 9,
            'indirect-first-instance': 10,
            'shader-f16': 11,
            'rg11b10ufloat-renderable': 12,
            'bgra8unorm-storage': 13,
            'float32-filterable': 14,
            'float32-blendable': 15,
            'clip-distances': 16,
            'dual-source-blending': 17,
            'subgroups': 18,
            'texture-formats-tier1': 19,
            'texture-formats-tier2': 20,
            'primitive-index': 21,
            'chromium-experimental-unorm16-texture-formats': 327692,
            'chromium-experimental-snorm16-texture-formats': 327693,
            'chromium-experimental-multi-draw-indirect': 327732,
        }\`,
        $emwgpuStringToInt_PreferredFormat: \`{
            'rgba8unorm': 22,
            'bgra8unorm': 27,
        }\`,
`;

    // Maps from enum number to enum string.
    // These appear in the final build result so should be kept minimal.
    // TODO(crbug.com/377760848): Investigate whether Closure is able
    // to dead-code-eliminate these; if not, make them library-level
    // items like the string-to-int tables.
    globalThis.WEBGPU_INT_TO_STRING_TABLES = `
        AddressMode: [
            ,
            'clamp-to-edge',
            'repeat',
            'mirror-repeat',
        ],
        BlendFactor: [
            ,
            'zero',
            'one',
            'src',
            'one-minus-src',
            'src-alpha',
            'one-minus-src-alpha',
            'dst',
            'one-minus-dst',
            'dst-alpha',
            'one-minus-dst-alpha',
            'src-alpha-saturated',
            'constant',
            'one-minus-constant',
            'src1',
            'one-minus-src1',
            'src1alpha',
            'one-minus-src1alpha',
        ],
        BlendOperation: [
            ,
            'add',
            'subtract',
            'reverse-subtract',
            'min',
            'max',
        ],
        BufferBindingType: [
            'binding-not-used',
            ,
            'uniform',
            'storage',
            'read-only-storage',
        ],
        BufferMapState: [
            ,
            'unmapped',
            'pending',
            'mapped',
        ],
        CompareFunction: [
            ,
            'never',
            'less',
            'equal',
            'less-equal',
            'greater',
            'not-equal',
            'greater-equal',
            'always',
        ],
        CompilationInfoRequestStatus: [
            ,
            'success',
            'callback-cancelled',
        ],
        CompositeAlphaMode: [
            ,
            'opaque',
            'premultiplied',
            'unpremultiplied',
            'inherit',
        ],
        CullMode: [
            ,
            'none',
            'front',
            'back',
        ],
        ErrorFilter: [
            ,
            'validation',
            'out-of-memory',
            'internal',
        ],
        FeatureLevel: [
            ,
            'compatibility',
            'core',
        ],
        FeatureName: {
            1: 'core-features-and-limits',
            2: 'depth-clip-control',
            3: 'depth32float-stencil8',
            4: 'texture-compression-bc',
            5: 'texture-compression-bc-sliced-3d',
            6: 'texture-compression-etc2',
            7: 'texture-compression-astc',
            8: 'texture-compression-astc-sliced-3d',
            9: 'timestamp-query',
            10: 'indirect-first-instance',
            11: 'shader-f16',
            12: 'rg11b10ufloat-renderable',
            13: 'bgra8unorm-storage',
            14: 'float32-filterable',
            15: 'float32-blendable',
            16: 'clip-distances',
            17: 'dual-source-blending',
            18: 'subgroups',
            19: 'texture-formats-tier1',
            20: 'texture-formats-tier2',
            21: 'primitive-index',
            327692: 'chromium-experimental-unorm16-texture-formats',
            327693: 'chromium-experimental-snorm16-texture-formats',
            327732: 'chromium-experimental-multi-draw-indirect',
        },
        FilterMode: [
            ,
            'nearest',
            'linear',
        ],
        FrontFace: [
            ,
            'ccw',
            'cw',
        ],
        IndexFormat: [
            ,
            'uint16',
            'uint32',
        ],
        InstanceFeatureName: [
            ,
            'timed-wait-any',
            'shader-source-spirv',
            'multiple-devices-per-adapter',
        ],
        LoadOp: [
            ,
            'load',
            'clear',
        ],
        MipmapFilterMode: [
            ,
            'nearest',
            'linear',
        ],
        OptionalBool: [
            'false',
            'true',
            ,
        ],
        PowerPreference: [
            ,
            'low-power',
            'high-performance',
        ],
        PredefinedColorSpace: [
            ,
            'srgb',
            'display-p3',
        ],
        PrimitiveTopology: [
            ,
            'point-list',
            'line-list',
            'line-strip',
            'triangle-list',
            'triangle-strip',
        ],
        QueryType: [
            ,
            'occlusion',
            'timestamp',
        ],
        SamplerBindingType: [
            'binding-not-used',
            ,
            'filtering',
            'non-filtering',
            'comparison',
        ],
        Status: [
            ,
            'success',
            'error',
        ],
        StencilOperation: [
            ,
            'keep',
            'zero',
            'replace',
            'invert',
            'increment-clamp',
            'decrement-clamp',
            'increment-wrap',
            'decrement-wrap',
        ],
        StorageTextureAccess: [
            'binding-not-used',
            ,
            'write-only',
            'read-only',
            'read-write',
        ],
        StoreOp: [
            ,
            'store',
            'discard',
        ],
        SurfaceGetCurrentTextureStatus: [
            ,
            'success-optimal',
            'success-suboptimal',
            'timeout',
            'outdated',
            'lost',
            'error',
        ],
        TextureAspect: [
            ,
            'all',
            'stencil-only',
            'depth-only',
        ],
        TextureDimension: [
            ,
            '1d',
            '2d',
            '3d',
        ],
        TextureFormat: [
            ,
            'r8unorm',
            'r8snorm',
            'r8uint',
            'r8sint',
            'r16unorm',
            'r16snorm',
            'r16uint',
            'r16sint',
            'r16float',
            'rg8unorm',
            'rg8snorm',
            'rg8uint',
            'rg8sint',
            'r32float',
            'r32uint',
            'r32sint',
            'rg16unorm',
            'rg16snorm',
            'rg16uint',
            'rg16sint',
            'rg16float',
            'rgba8unorm',
            'rgba8unorm-srgb',
            'rgba8snorm',
            'rgba8uint',
            'rgba8sint',
            'bgra8unorm',
            'bgra8unorm-srgb',
            'rgb10a2uint',
            'rgb10a2unorm',
            'rg11b10ufloat',
            'rgb9e5ufloat',
            'rg32float',
            'rg32uint',
            'rg32sint',
            'rgba16unorm',
            'rgba16snorm',
            'rgba16uint',
            'rgba16sint',
            'rgba16float',
            'rgba32float',
            'rgba32uint',
            'rgba32sint',
            'stencil8',
            'depth16unorm',
            'depth24plus',
            'depth24plus-stencil8',
            'depth32float',
            'depth32float-stencil8',
            'bc1-rgba-unorm',
            'bc1-rgba-unorm-srgb',
            'bc2-rgba-unorm',
            'bc2-rgba-unorm-srgb',
            'bc3-rgba-unorm',
            'bc3-rgba-unorm-srgb',
            'bc4-r-unorm',
            'bc4-r-snorm',
            'bc5-rg-unorm',
            'bc5-rg-snorm',
            'bc6h-rgb-ufloat',
            'bc6h-rgb-float',
            'bc7-rgba-unorm',
            'bc7-rgba-unorm-srgb',
            'etc2-rgb8unorm',
            'etc2-rgb8unorm-srgb',
            'etc2-rgb8a1unorm',
            'etc2-rgb8a1unorm-srgb',
            'etc2-rgba8unorm',
            'etc2-rgba8unorm-srgb',
            'eac-r11unorm',
            'eac-r11snorm',
            'eac-rg11unorm',
            'eac-rg11snorm',
            'astc-4x4-unorm',
            'astc-4x4-unorm-srgb',
            'astc-5x4-unorm',
            'astc-5x4-unorm-srgb',
            'astc-5x5-unorm',
            'astc-5x5-unorm-srgb',
            'astc-6x5-unorm',
            'astc-6x5-unorm-srgb',
            'astc-6x6-unorm',
            'astc-6x6-unorm-srgb',
            'astc-8x5-unorm',
            'astc-8x5-unorm-srgb',
            'astc-8x6-unorm',
            'astc-8x6-unorm-srgb',
            'astc-8x8-unorm',
            'astc-8x8-unorm-srgb',
            'astc-10x5-unorm',
            'astc-10x5-unorm-srgb',
            'astc-10x6-unorm',
            'astc-10x6-unorm-srgb',
            'astc-10x8-unorm',
            'astc-10x8-unorm-srgb',
            'astc-10x10-unorm',
            'astc-10x10-unorm-srgb',
            'astc-12x10-unorm',
            'astc-12x10-unorm-srgb',
            'astc-12x12-unorm',
            'astc-12x12-unorm-srgb',
        ],
        TextureSampleType: [
            'binding-not-used',
            ,
            'float',
            'unfilterable-float',
            'depth',
            'sint',
            'uint',
        ],
        TextureViewDimension: [
            ,
            '1d',
            '2d',
            '2d-array',
            'cube',
            'cube-array',
            '3d',
        ],
        ToneMappingMode: [
            ,
            'standard',
            'extended',
        ],
        VertexFormat: [
            ,
            'uint8',
            'uint8x2',
            'uint8x4',
            'sint8',
            'sint8x2',
            'sint8x4',
            'unorm8',
            'unorm8x2',
            'unorm8x4',
            'snorm8',
            'snorm8x2',
            'snorm8x4',
            'uint16',
            'uint16x2',
            'uint16x4',
            'sint16',
            'sint16x2',
            'sint16x4',
            'unorm16',
            'unorm16x2',
            'unorm16x4',
            'snorm16',
            'snorm16x2',
            'snorm16x4',
            'float16',
            'float16x2',
            'float16x4',
            'float32',
            'float32x2',
            'float32x3',
            'float32x4',
            'uint32',
            'uint32x2',
            'uint32x3',
            'uint32x4',
            'sint32',
            'sint32x2',
            'sint32x3',
            'sint32x4',
            'unorm10-10-10-2',
            'unorm8x4-bgra',
        ],
        VertexStepMode: [
            ,
            'vertex',
            'instance',
        ],
        WGSLLanguageFeatureName: [
            ,
            'readonly_and_readwrite_storage_textures',
            'packed_4x8_integer_dot_product',
            'unrestricted_pointer_parameters',
            'pointer_composite_access',
        ],
`;

    null;
}}}
