#ifndef NVK_ENUMS_
#define NVK_ENUMS_

namespace nv {

enum BasicEventType {
    EVT_GL_CONTEXT_MADE_CURRENT,
};

enum DataType {
    DTYPE_UNKNOWN,
    DTYPE_BOOL,
    DTYPE_U8,
    DTYPE_I8,
    DTYPE_U16,
    DTYPE_I16,
    DTYPE_U32,
    DTYPE_I32,
    DTYPE_U64,
    DTYPE_I64,
    DTYPE_F16,
    DTYPE_F32,
    DTYPE_F64,
    DTYPE_VEC2I,
    DTYPE_VEC2U,
    DTYPE_VEC2F,
    DTYPE_VEC2D,
    DTYPE_VEC3I,
    DTYPE_VEC3U,
    DTYPE_VEC3F,
    DTYPE_VEC3D,
    DTYPE_VEC4I,
    DTYPE_VEC4U,
    DTYPE_VEC4F,
    DTYPE_VEC4D,
    DTYPE_MAT4F,
    DTYPE_MAT4D,
    DTYPE_OTHER,
};

enum EventType {
    EVENT_MOUSE_MOTION,
    EVENT_MOUSE_BUTTON_PRESS,
    EVENT_MOUSE_BUTTON_RELEASE,
    EVENT_MOUSE_ENTER,
    EVENT_MOUSE_LEAVE,
    EVENT_KEY_PRESS,
    EVENT_KEY_RELEASE,
    EVENT_FOCUS_OBTAINED,
    EVENT_FOCUS_LOST,
    EVENT_SCREEN_RESIZE,
    EVENT_WINDOW_CLOSING,
};

enum Alignment {
    ALIGN_NONE = 0,
    ALIGN_HCENTER = 1 << 0,
    ALIGN_VCENTER = 1 << 1,
    ALIGN_LEFT = 1 << 2,
    ALIGN_RIGHT = 1 << 3,
    ALIGN_TOP = 1 << 4,
    ALIGN_BOTTOM = 1 << 5,
    ALIGN_BASELINE = 1 << 6,
    ALIGN_FRONT = 1 << 7,
    ALIGN_BACK = 1 << 8,
    ALIGN_CENTER = ALIGN_HCENTER | ALIGN_VCENTER,
};

enum AnchorType {
    ANCHOR_NONE,
    ANCHOR_BOTTOM_LEFT,
    ANCHOR_BOTTOM_CENTER,
    ANCHOR_BOTTOM_RIGHT,
    ANCHOR_BASE_LEFT,
    ANCHOR_BASE_CENTER,
    ANCHOR_BASE_RIGHT,
    ANCHOR_CENTER_LEFT,
    ANCHOR_CENTER_CENTER,
    ANCHOR_CENTER_RIGHT,
    ANCHOR_TOP_LEFT,
    ANCHOR_TOP_CENTER,
    ANCHOR_TOP_RIGHT,
};

} // namespace nv

#endif
