file(STRINGS gpl_package_list.txt package_list)

foreach(LINE ${package_list})
  string(REGEX MATCH "^[^ ]*" PACKAGE_NAME ${LINE})
  string(REPLACE "/" "_" PACKAGE_CODE_NAME ${PACKAGE_NAME})
  string(TOUPPER ${PACKAGE_CODE_NAME} PACKAGE_CODE_NAME)
  string(REGEX MATCH " (.*)" PACKAGE_DESCRIPTION ${LINE})
  string(STRIP "${PACKAGE_DESCRIPTION}" PACKAGE_PRETTY_NAME)
  if(NOT PACKAGE_PRETTY_NAME)
    set(PACKAGE_PRETTY_NAME ${PACKAGE_NAME})
  endif()
  message("Generate \"${PACKAGE_NAME}.h\"")
  configure_file(gpl.h.in ${PACKAGE_NAME}.h @ONLY NEWLINE_STYLE LF)
endforeach()
